package sample.sample16;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import org.apache.log4j.Logger;

public class Sample16_10 {

	private static final Logger logger = Logger.getLogger(Sample16_10.class);

	public static void main(String[] args) throws ParseException {
		Locale locale = new Locale("ja", "JP", "JP");
		DateFormat format = new SimpleDateFormat("GGGGyyNMMdd", locale);
		logger.debug(format.format(new Date()));

		Locale.setDefault(locale);
		format = new SimpleDateFormat("GyyNMMdd");
		logger.debug(format.format(new Date()));

		Calendar cal = Calendar.getInstance(locale);
		int eraValue = cal.get(Calendar.ERA);
		logger.debug(ɕϊ(eraValue));
	}

	private static String ɕϊ(int eraValue) {
		switch (eraValue) {
		case 0:
			return "ȑO";
		case 1:
			return "";
		case 2:
			return "吳";
		case 3:
			return "a";
		case 4:
			return "";
		default:
			throw new IllegalArgumentException();
		}
	}
}
