package sample.sample16;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.log4j.Logger;

public class Sample16_9 {

	private static final Logger logger = Logger.getLogger(Sample16_9.class);

	public static void main(String[] args) throws ParseException {
		Date date = new Date();
		logger.debug("Date#toString() : " + date.toString() + "\n");

		DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
		logger.debug("DateFormatg(1) : " + dateFormat.format(date));

		dateFormat = new SimpleDateFormat("yyNMMdd(E) HH:mm:ss");
		logger.debug("DateFormatg(2) : " + dateFormat.format(date) + "\n");

		Calendar calendar = Calendar.getInstance();
		date = calendar.getTime();
		logger.debug("Calendar쐬Date : " + dateFormat.format(date));

		calendar.clear();
		date = calendar.getTime();
		logger.debug("Calendar#clear() : " + dateFormat.format(date));

		calendar.set(Calendar.YEAR, 2010);
		calendar.set(Calendar.MONTH, 0);
		calendar.set(Calendar.DAY_OF_MONTH, 31);
		calendar.set(Calendar.HOUR_OF_DAY, 13);
		calendar.set(Calendar.MINUTE, 35);
		date = calendar.getTime();
		logger.debug("Calendarœw肵Date : " + dateFormat.format(date));

		calendar.add(Calendar.DAY_OF_MONTH, 1);
		date = calendar.getTime();
		logger.debug("1ǉ : " + dateFormat.format(date) + "\n");

		int year = calendar.get(Calendar.YEAR);
		int month = calendar.get(Calendar.MONTH);
		int day = calendar.get(Calendar.DAY_OF_MONTH);

		logger.debug(year + "(NłB)");
		logger.debug(month + "(łB`Ԗڂ̌ƂӖB)");
		logger.debug(day + "(łB)" + "\n");

		dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
		date = dateFormat.parse("2022/01/25 23:55:11");

		logger.debug("񂩂Date쐬 : " + dateFormat.format(date) + "\n");

		logger.debug("String#format(String, Object...)g(1) : "
				+ String.format("%tY/%tm/%td", date, date, date));
		logger.debug("String#format(String, Object...)g(2) : "
				+ String.format("%tY/%<tm/%<td", date));
	}
}
