package sample.sample19;

import static org.junit.Assert.*;

import org.junit.Test;

public class CalcTest {

	@Test
	public void testAdd() {
		String actual = Calc.add("3", "1");
		assertEquals("3+1=4", "4.00", actual);
	}

	@Test
	public void ̑Z() {
		assertEquals("4.20", Calc.add("3.1", "1.1"));
	}

	@Test
	public void _3ȉ܂ޑZ() {
		assertEquals("0.00", Calc.add("0", "0.004"));
		assertEquals("0.00", Calc.add("0", "0.005"));
		assertEquals("0.01", Calc.add("0", "0.0050000000001"));
	}

	@Test
	public void ̐̑Z() {
		assertEquals("-1.00", Calc.add("1", "-2"));
		assertEquals("2.23", Calc.add("-4", "6.23"));
		assertEquals("-10.23", Calc.add("-4", "-6.23"));
	}

	@Test(expected = NullPointerException.class)
	public void Null̂Ƃ() throws Exception {
		Calc.add(null, "-2");
	}

	@Test
	public void Null̂Ƃ() throws Exception {
		try {
			Calc.add("1", null);
			fail();
		} catch (NullPointerException success) {
			assertNull(success.getMessage());
		}
	}

	@Test
	public void ̑傫Ȑ̑Z() {
		StringBuilder bigNum = new StringBuilder();
		StringBuilder expected = new StringBuilder();
		for (int i = 0; i < 2000; i++) {
			bigNum.append("1");
			expected.append("2");
		}
		expected.append(".00");

		String actual = Calc.add(bigNum.toString(), bigNum.toString());
		assertEquals(expected.toString(), actual);
	}
}
