package sample.sample19;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

public class DataFinderTest {
	private DataFinder dataFinder = new DataFinder();

	@Before
	public void MockPersonDataAccessorZbg() {
		PersonDataAccessor accessorMock = new PersonDataAccessorMock();
		dataFinder.setAccessor(accessorMock);
	}

	@Test
	public void testFindPerson() {
		List<Person> expected = new ArrayList<Person>();
		expected.add(new Person("Ƃ", "saJ", "03-9999-9999"));
		expected.add(new Person("tWq", "si", "03-7777-7777"));

		assertEquals(expected, dataFinder.findPerson(""));

		expected = new ArrayList<Person>();
		expected.add(new Person("؂q", "s`", "03-8888-8888"));
		expected.add(new Person("tWq", "si", "03-7777-7777"));

		assertEquals(expected, dataFinder.findPerson("q"));
	}

	@Test
	public void ʂȂp^[() {
		assertEquals(0, dataFinder.findPerson("ɓ").size());
	}

}
