/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.hsqldb.lib.BasicTextJdkLogFormatter;

public class FrameworkLogger {
    private static Map loggerInstances = new HashMap();
    private static Map jdkToLog4jLevels = new HashMap();
    private static Method log4jGetLogger;
    private static Method log4jLogMethod;
    private Object log4jLogger;
    private Logger jdkLogger;
    private static boolean haveLoadedOurDefault;
    private static ConsoleHandler consoleHandler;

    public static String report() {
        return loggerInstances.size() + " logger instances:  " + loggerInstances.keySet();
    }

    public static synchronized void clearLoggers(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = loggerInstances.keySet().iterator();
        String string2 = string + '.';
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.equals(string) && !string3.startsWith(string2)) continue;
            hashSet.add(string3);
        }
        loggerInstances.keySet().removeAll(hashSet);
    }

    static void reconfigure() {
        Class<?> clazz = null;
        loggerInstances.clear();
        try {
            clazz = Class.forName("org.apache.log4j.Logger");
        }
        catch (Exception exception) {
            clazz = null;
        }
        if (clazz == null) {
            try {
                log4jGetLogger = null;
                log4jLogMethod = null;
                LogManager logManager = LogManager.getLogManager();
                if (haveLoadedOurDefault || FrameworkLogger.isDefaultJdkConfig()) {
                    haveLoadedOurDefault = true;
                    consoleHandler.setFormatter(new BasicTextJdkLogFormatter(false));
                    consoleHandler.setLevel(Level.INFO);
                    logManager.readConfiguration(FrameworkLogger.class.getResourceAsStream("/org/hsqldb/resources/jdklogging-default.properties"));
                    Logger logger = Logger.getLogger("org.hsqldb.cmdline");
                    logger.addHandler(consoleHandler);
                    logger.setUseParentHandlers(false);
                }
                logManager.readConfiguration();
            }
            catch (Exception exception) {
                throw new RuntimeException("<clinit> failure initializing JDK logging system", exception);
            }
        } else {
            try {
                Method method = Class.forName("org.apache.log4j.Level").getMethod("toLevel", String.class);
                jdkToLog4jLevels.put(Level.ALL, method.invoke(null, "ALL"));
                jdkToLog4jLevels.put(Level.FINER, method.invoke(null, "DEBUG"));
                jdkToLog4jLevels.put(Level.WARNING, method.invoke(null, "ERROR"));
                jdkToLog4jLevels.put(Level.SEVERE, method.invoke(null, "FATAL"));
                jdkToLog4jLevels.put(Level.INFO, method.invoke(null, "INFO"));
                jdkToLog4jLevels.put(Level.OFF, method.invoke(null, "OFF"));
                jdkToLog4jLevels.put(Level.FINEST, method.invoke(null, "TRACE"));
                jdkToLog4jLevels.put(Level.WARNING, method.invoke(null, "WARN"));
                log4jLogMethod = clazz.getMethod("log", String.class, Class.forName("org.apache.log4j.Priority"), Object.class, Throwable.class);
                log4jGetLogger = clazz.getMethod("getLogger", String.class);
            }
            catch (Exception exception) {
                throw new RuntimeException("<clinit> failure instantiating present Log4j system", exception);
            }
        }
    }

    private FrameworkLogger(String string) {
        if (log4jGetLogger == null) {
            this.jdkLogger = Logger.getLogger(string);
        } else {
            try {
                this.log4jLogger = log4jGetLogger.invoke(null, string);
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to instantiate Log4j Logger", exception);
            }
        }
        loggerInstances.put(string, this);
    }

    public static FrameworkLogger getLog(Class clazz) {
        return FrameworkLogger.getLog(clazz.getName());
    }

    public static FrameworkLogger getLog(Class clazz, String string) {
        return string == null ? FrameworkLogger.getLog(clazz) : FrameworkLogger.getLog(string + '.' + clazz.getName());
    }

    public static FrameworkLogger getLog(String string, String string2) {
        return string2 == null ? FrameworkLogger.getLog(string) : FrameworkLogger.getLog(string2 + '.' + string);
    }

    public static FrameworkLogger getLog(String string) {
        if (loggerInstances.containsKey(string)) {
            return (FrameworkLogger)loggerInstances.get(string);
        }
        return new FrameworkLogger(string);
    }

    public void log(Level level, String string, Throwable throwable) {
        this.privlog(level, string, throwable, 2, FrameworkLogger.class);
    }

    public void privlog(Level level, String string, Throwable throwable, int n, Class clazz) {
        if (this.log4jLogger == null) {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            String string2 = stackTraceElementArray[n].getClassName();
            String string3 = stackTraceElementArray[n].getMethodName();
            if (throwable == null) {
                this.jdkLogger.logp(level, string2, string3, string);
            } else {
                this.jdkLogger.logp(level, string2, string3, string, throwable);
            }
        } else {
            try {
                log4jLogMethod.invoke(this.log4jLogger, clazz.getName(), jdkToLog4jLevels.get(level), string, throwable);
            }
            catch (Exception exception) {
                throw new RuntimeException("Logging failed when attempting to log: " + string, exception);
            }
        }
    }

    public void enduserlog(Level level, String string) {
        if (this.log4jLogger == null) {
            String string2 = FrameworkLogger.class.getName();
            String string3 = "\\l";
            this.jdkLogger.logp(level, string2, string3, string);
        } else {
            try {
                log4jLogMethod.invoke(this.log4jLogger, FrameworkLogger.class.getName(), jdkToLog4jLevels.get(level), string, null);
            }
            catch (Exception exception) {
                throw new RuntimeException("Logging failed when attempting to log: " + string, exception);
            }
        }
    }

    public void log(Level level, String string) {
        this.privlog(level, string, null, 2, FrameworkLogger.class);
    }

    public void finer(String string) {
        this.privlog(Level.FINER, string, null, 2, FrameworkLogger.class);
    }

    public void warning(String string) {
        this.privlog(Level.WARNING, string, null, 2, FrameworkLogger.class);
    }

    public void severe(String string) {
        this.privlog(Level.SEVERE, string, null, 2, FrameworkLogger.class);
    }

    public void info(String string) {
        this.privlog(Level.INFO, string, null, 2, FrameworkLogger.class);
    }

    public void finest(String string) {
        this.privlog(Level.FINEST, string, null, 2, FrameworkLogger.class);
    }

    public void error(String string) {
        this.privlog(Level.WARNING, string, null, 2, FrameworkLogger.class);
    }

    public void finer(String string, Throwable throwable) {
        this.privlog(Level.FINER, string, throwable, 2, FrameworkLogger.class);
    }

    public void warning(String string, Throwable throwable) {
        this.privlog(Level.WARNING, string, throwable, 2, FrameworkLogger.class);
    }

    public void severe(String string, Throwable throwable) {
        this.privlog(Level.SEVERE, string, throwable, 2, FrameworkLogger.class);
    }

    public void info(String string, Throwable throwable) {
        this.privlog(Level.INFO, string, throwable, 2, FrameworkLogger.class);
    }

    public void finest(String string, Throwable throwable) {
        this.privlog(Level.FINEST, string, throwable, 2, FrameworkLogger.class);
    }

    public void error(String string, Throwable throwable) {
        this.privlog(Level.WARNING, string, throwable, 2, FrameworkLogger.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDefaultJdkConfig() {
        File file = new File(System.getProperty("java.home"), "lib/logging.properties");
        if (!file.isFile()) {
            return false;
        }
        FileInputStream fileInputStream = null;
        LogManager logManager = LogManager.getLogManager();
        try {
            fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Enumeration<?> enumeration = properties.propertyNames();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                ++n;
                String string = (String)enumeration.nextElement();
                String string2 = logManager.getProperty(string);
                if (string2 == null) {
                    boolean bl = false;
                    return bl;
                }
                if (logManager.getProperty(string).equals(string2)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        consoleHandler = new ConsoleHandler();
        String string = System.getProperty("hsqldb.reconfig_logging");
        if (string == null || !string.equalsIgnoreCase("false")) {
            FrameworkLogger.reconfigure();
        }
    }
}

