package chapter6.controller.session;

import java.util.List;

import javax.servlet.http.HttpSession;

import chapter6.beans.User;

public class SessionHelper {

	private HttpSession session;

	public SessionHelper(HttpSession session) {
		this.session = session;
	}

	public User getLoginUser() {
		return (User) session.getAttribute("loginUser");
	}

	public void setLoginUser(User loginUser) {
		session.setAttribute("loginUser", loginUser);
	}

	public List<String> getErrorMessages() {
		@SuppressWarnings("unchecked")
		List<String> ret = (List<String>) session.getAttribute("errorMessages");
		return ret;
	}

	public void setErrorMessages(List<String> errorMessages) {
		session.setAttribute("errorMessages", errorMessages);
	}

	public User getEditUser() {
		return (User) session.getAttribute("editUser");
	}

	public void setEditUser(User editUser) {
		session.setAttribute("editUser", editUser);
	}

}
