/*
 * Decompiled with CFR 0.152.
 */
package jp.dodododo.jassert;

import jp.dodododo.jassert.ConclusionType1;
import jp.dodododo.jassert.ConclusionType2;
import jp.dodododo.jassert.Conjunction;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jassert {
    public static final Conjunction \u3068 = Conjunction.\u3068;
    public static final ConclusionType1 \u306fTrue = ConclusionType1.\u306fTrue;
    public static final ConclusionType1 \u306fFalse = ConclusionType1.\u306fFalse;
    public static final ConclusionType1 \u306fnull = ConclusionType1.\u306fnull;
    public static final ConclusionType1 \u306fnull\u3067\u306f\u306a\u3044 = ConclusionType1.\u306fnull\u3067\u306f\u306a\u3044;
    public static final ConclusionType2 \u306f\u53c2\u7167\u304c\u540c\u3058 = ConclusionType2.\u306f\u53c2\u7167\u304c\u540c\u3058;
    public static final ConclusionType2 \u306f\u53c2\u7167\u5148\u304c\u540c\u3058 = ConclusionType2.\u306f\u53c2\u7167\u5148\u304c\u540c\u3058;
    public static final ConclusionType2 \u306f\u53c2\u7167\u304c\u7570\u306a\u308b = ConclusionType2.\u306f\u53c2\u7167\u304c\u7570\u306a\u308b;
    public static final ConclusionType2 \u306f\u53c2\u7167\u5148\u304c\u7570\u306a\u308b = ConclusionType2.\u306f\u53c2\u7167\u5148\u304c\u7570\u306a\u308b;
    public static final ConclusionType2 \u306f\u53c2\u7167\u5148\u304c\u540c\u3058\u3067\u306f\u306a\u3044 = ConclusionType2.\u306f\u53c2\u7167\u5148\u304c\u540c\u3058\u3067\u306f\u306a\u3044;
    public static final ConclusionType2 \u306f\u7b49\u3057\u3044 = ConclusionType2.\u306f\u7b49\u3057\u3044;
    public static final ConclusionType2 \u306f\u540c\u3058\u5024 = ConclusionType2.\u306f\u540c\u3058\u5024;
    public static final ConclusionType2 \u306f\u7b49\u3057\u304f\u306a\u3044 = ConclusionType2.\u306f\u7b49\u3057\u304f\u306a\u3044;
    public static final ConclusionType2 \u306f\u540c\u3058\u5024\u3067\u306f\u306a\u3044 = ConclusionType2.\u306f\u540c\u3058\u5024\u3067\u306f\u306a\u3044;
    public static final ConclusionType2 \u306f\u7570\u306a\u308b\u5024 = ConclusionType2.\u306f\u7570\u306a\u308b\u5024;

    public static <T> void \u30a2\u30b5\u30fc\u30c8(T actual, Matcher<T> matcher) {
        Jassert.doAssert(actual, matcher);
    }

    public static <T> void \u30a2\u30b5\u30fc\u30c8(String message, T actual, Matcher<T> matcher) {
        Jassert.doAssert(message, actual, matcher);
    }

    public static <T> void doAssert(T actual, Matcher<T> matcher) {
        Jassert.doAssert("", actual, matcher);
    }

    public static <T> void doAssert(String message, T actual, Matcher<T> matcher) {
        Jassert.assertThat(message, actual, matcher);
    }

    public static <T> void assertThat(T actual, Matcher<T> matcher) {
        Jassert.assertThat("", actual, matcher);
    }

    public static <T> void assertThat(String message, T actual, Matcher<T> matcher) {
        if (!matcher.matches(actual)) {
            StringDescription description = new StringDescription();
            description.appendText(message);
            description.appendText("\nExpected: ");
            matcher.describeTo((Description)description);
            description.appendText("\n     got: ").appendValue(actual).appendText("\n");
            throw new AssertionError((Object)description.toString());
        }
    }

    public static void doAssert(Object \u7d50\u679c, Conjunction \u3068, Object \u4e88\u60f3, ConclusionType2 \u7d50\u8ad6) {
        Jassert.doAssert("", \u7d50\u679c, \u3068, \u4e88\u60f3, \u7d50\u8ad6);
    }

    public static void \u30a2\u30b5\u30fc\u30c8(Object \u7d50\u679c, Conjunction \u3068, Object \u4e88\u60f3, ConclusionType2 \u7d50\u8ad6) {
        Jassert.doAssert(\u7d50\u679c, \u3068, \u4e88\u60f3, \u7d50\u8ad6);
    }

    public static void doAssert(Object \u4e88\u60f3, ConclusionType1 \u7d50\u8ad6) {
        Jassert.doAssert("", \u4e88\u60f3, \u7d50\u8ad6);
    }

    public static void \u30a2\u30b5\u30fc\u30c8(Object \u4e88\u60f3, ConclusionType1 \u7d50\u8ad6) {
        Jassert.doAssert(\u4e88\u60f3, \u7d50\u8ad6);
    }

    public static void \u30a2\u30b5\u30fc\u30c8(String message, Object \u4e88\u60f3, ConclusionType1 \u7d50\u8ad6) {
        Jassert.doAssert(message, \u4e88\u60f3, \u7d50\u8ad6);
    }

    public static void doAssert(String message, Object \u4e88\u60f3, ConclusionType1 \u7d50\u8ad6) {
        switch (\u7d50\u8ad6) {
            case \u306fTrue: {
                Assert.assertTrue((String)message, (boolean)Jassert.toBoolean(\u4e88\u60f3));
                break;
            }
            case \u306fFalse: {
                Assert.assertFalse((String)message, (boolean)Jassert.toBoolean(\u4e88\u60f3));
                break;
            }
            case \u306fnull: {
                Assert.assertNull((String)message, (Object)\u4e88\u60f3);
                break;
            }
            case \u306fnull\u3067\u306f\u306a\u3044: {
                Assert.assertNotNull((String)message, (Object)\u4e88\u60f3);
                break;
            }
            default: {
                throw new IllegalArgumentException("" + (Object)((Object)\u7d50\u8ad6));
            }
        }
    }

    public static void \u30a2\u30b5\u30fc\u30c8(String message, Object \u7d50\u679c, Conjunction \u3068, Object \u4e88\u60f3, ConclusionType2 \u7d50\u8ad6) {
        Jassert.doAssert(message, \u7d50\u679c, \u3068, \u4e88\u60f3, \u7d50\u8ad6);
    }

    public static void doAssert(String message, Object \u7d50\u679c, Conjunction \u3068, Object \u4e88\u60f3, ConclusionType2 \u7d50\u8ad6) {
        switch (\u7d50\u8ad6) {
            case \u306f\u53c2\u7167\u304c\u540c\u3058: {
                Assert.assertSame((String)message, (Object)\u4e88\u60f3, (Object)\u7d50\u679c);
                break;
            }
            case \u306f\u53c2\u7167\u304c\u7570\u306a\u308b: 
            case \u306f\u53c2\u7167\u5148\u304c\u540c\u3058\u3067\u306f\u306a\u3044: 
            case \u306f\u53c2\u7167\u5148\u304c\u7570\u306a\u308b: {
                Assert.assertNotSame((String)message, (Object)\u4e88\u60f3, (Object)\u7d50\u679c);
                break;
            }
            case \u306f\u7b49\u3057\u3044: 
            case \u306f\u540c\u3058\u5024: {
                Assert.assertEquals((String)message, (Object)\u4e88\u60f3, (Object)\u7d50\u679c);
                break;
            }
            case \u306f\u7570\u306a\u308b\u5024: 
            case \u306f\u7b49\u3057\u304f\u306a\u3044: 
            case \u306f\u540c\u3058\u5024\u3067\u306f\u306a\u3044: {
                Jassert.assertNotEquals(message, \u4e88\u60f3, \u7d50\u679c);
                break;
            }
            default: {
                throw new IllegalArgumentException("" + (Object)((Object)\u7d50\u8ad6));
            }
        }
    }

    public static final void success(String message) {
    }

    public static final void success() {
    }

    public static final void \u6210\u529f(String message) {
    }

    public static final void \u6210\u529f() {
    }

    public static final void \u5931\u6557(String message) {
        Jassert.fail(message);
    }

    public static final void \u5931\u6557() {
        Jassert.fail();
    }

    public static final void fail(String message) {
        Assert.fail((String)message);
    }

    public static final void fail() {
        Jassert.fail("");
    }

    private static void assertNotEquals(String message, Object \u4e88\u60f3, Object \u7d50\u679c) {
        boolean success = false;
        try {
            Assert.assertEquals((String)message, (Object)\u4e88\u60f3, (Object)\u7d50\u679c);
        }
        catch (AssertionFailedError e) {
            success = true;
        }
        if (!success) {
            Jassert.fail(message);
        }
    }

    private static boolean toBoolean(Object val) {
        if (val instanceof Boolean) {
            Boolean bool = (Boolean)val;
            return bool;
        }
        throw new IllegalArgumentException("" + val);
    }
}

