package jp.dodododo.jassert;

import static junit.framework.Assert.*;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

/**
 * @author Satoshi Kimura
 */
public class Jassert {
	public static final Conjunction と = Conjunction.と;

	public static final ConclusionType1 はTrue = ConclusionType1.はTrue;

	public static final ConclusionType1 はFalse = ConclusionType1.はFalse;

	public static final ConclusionType1 はnull = ConclusionType1.はnull;

	public static final ConclusionType1 はnullではない = ConclusionType1.はnullではない;

	public static final ConclusionType2 は参照が同じ = ConclusionType2.は参照が同じ;

	public static final ConclusionType2 は参照先が同じ = ConclusionType2.は参照先が同じ;

	public static final ConclusionType2 は参照が異なる = ConclusionType2.は参照が異なる;

	public static final ConclusionType2 は参照先が異なる = ConclusionType2.は参照先が異なる;

	public static final ConclusionType2 は参照先が同じではない = ConclusionType2.は参照先が同じではない;

	public static final ConclusionType2 は等しい = ConclusionType2.は等しい;

	public static final ConclusionType2 は同じ値 = ConclusionType2.は同じ値;

	public static final ConclusionType2 は等しくない = ConclusionType2.は等しくない;

	public static final ConclusionType2 は同じ値ではない = ConclusionType2.は同じ値ではない;

	public static final ConclusionType2 は異なる値 = ConclusionType2.は異なる値;

	public static <T> void アサート(T actual, Matcher<T> matcher) {
		doAssert(actual, matcher);
	}

	public static <T> void アサート(String message, T actual, Matcher<T> matcher) {
		doAssert(message, actual, matcher);
	}

	public static <T> void doAssert(T actual, Matcher<T> matcher) {
		doAssert("", actual, matcher);
	}

	public static <T> void doAssert(String message, T actual, Matcher<T> matcher) {
		assertThat(message, actual, matcher);
	}

	public static <T> void assertThat(T actual, Matcher<T> matcher) {
		assertThat("", actual, matcher);

	}

	public static <T> void assertThat(String message, T actual, Matcher<T> matcher) {
		if (!matcher.matches(actual)) {
			Description description = new StringDescription();
			description.appendText(message);
			description.appendText("\nExpected: ");
			matcher.describeTo(description);
			description.appendText("\n     got: ").appendValue(actual).appendText("\n");
			throw new java.lang.AssertionError(description.toString());
		}
	}

	public static void doAssert(Object 結果, Conjunction と, Object 予想, ConclusionType2 結論) {
		doAssert("", 結果, と, 予想, 結論);
	}

	public static void アサート(Object 結果, Conjunction と, Object 予想, ConclusionType2 結論) {
		doAssert(結果, と, 予想, 結論);
	}

	public static void doAssert(Object 予想, ConclusionType1 結論) {
		doAssert("", 予想, 結論);
	}

	public static void アサート(Object 予想, ConclusionType1 結論) {
		doAssert(予想, 結論);
	}

	public static void アサート(String message, Object 予想, ConclusionType1 結論) {
		doAssert(message, 予想, 結論);
	}

	public static void doAssert(String message, Object 予想, ConclusionType1 結論) {
		switch (結論) {
		case はTrue:
			assertTrue(message, toBoolean(予想));
			break;
		case はFalse:
			assertFalse(message, toBoolean(予想));
			break;
		case はnull:
			assertNull(message, 予想);
			break;
		case はnullではない:
			assertNotNull(message, 予想);
			break;
		default:
			throw new IllegalArgumentException("" + 結論);
		}
	}

	public static void アサート(String message, Object 結果, Conjunction と, Object 予想, ConclusionType2 結論) {
		doAssert(message, 結果, と, 予想, 結論);
	}

	public static void doAssert(String message, Object 結果, Conjunction と, Object 予想, ConclusionType2 結論) {
		switch (結論) {
		case は参照が同じ:
			assertSame(message, 予想, 結果);
			break;
		case は参照が異なる:
		case は参照先が同じではない:
		case は参照先が異なる:
			assertNotSame(message, 予想, 結果);
			break;
		case は等しい:
		case は同じ値:
			assertEquals(message, 予想, 結果);
			break;
		case は異なる値:
		case は等しくない:
		case は同じ値ではない:
			assertNotEquals(message, 予想, 結果);
			break;
		default:
			throw new IllegalArgumentException("" + 結論);
		}
	}

	public static final void success(String message) {
	}

	public static final void success() {
	}

	public static final void 成功(String message) {
	}

	public static final void 成功() {
	}

	public static final void 失敗(String message) {
		fail(message);
	}

	public static final void 失敗() {
		fail();
	}

	public static final void fail(String message) {
		junit.framework.Assert.fail(message);
	}

	public static final void fail() {
		fail("");
	}

	private static void assertNotEquals(String message, Object 予想, Object 結果) {
		boolean success = false;
		try {
			assertEquals(message, 予想, 結果);
		} catch (junit.framework.AssertionFailedError e) {
			success = true;
		}
		if (success == false) {
			fail(message);
		}
	}

	private static boolean toBoolean(Object val) {
		if (val instanceof Boolean) {
			Boolean bool = (Boolean) val;
			return bool.booleanValue();
		}
		throw new IllegalArgumentException("" + val);
	}

}
