package jp.dodododo.jassert;

import static jp.dodododo.jassert.Jassert.*;
import junit.framework.AssertionFailedError;

import org.junit.Test;

/**
 * @author Satoshi Kimura
 */
public class JassertTest {

	@Test
	public void testアサートObject結論1() {
		アサート(true, はTrue);
		try {
			アサート(false, はTrue);
			失敗();
		} catch (AssertionFailedError e) {
			成功();
		}

		アサート(false, はFalse);
		try {
			アサート(true, はFalse);
			失敗();
		} catch (AssertionFailedError e) {
			成功();
		}

		アサート(null, はnull);
		try {
			アサート(true, はnull);
			失敗();
		} catch (AssertionFailedError e) {
			成功();
		}

		アサート(true, はnullではない);
		try {
			アサート(null, はnullではない);
			失敗();
		} catch (AssertionFailedError e) {
			成功();
		}
	}

	@Test
	public void testアサートStringObject接続詞Object結論2() {
		アサート("message", "a", と, "a", は同じ値);
		try {
			アサート("message", "a", と, "b", は同じ値);
			失敗();
		} catch (AssertionFailedError e) {
			成功();
		}

		Object o = "a";
		アサート("message", o, と, o, は参照が同じ);
		try {
			アサート("message", o, と, "b", は参照が同じ);
			失敗();
		} catch (AssertionFailedError e) {
			成功();
		}

		アサート("message", "a", と, "b", は同じ値ではない);
		try {
			アサート("message", "a", と, "a", は同じ値ではない);
			失敗();
		} catch (AssertionFailedError e) {
			成功();
		}

		アサート("message", o, と, "b", は参照が異なる);
		try {
			アサート("message", o, と, o, は参照が異なる);
			失敗();
		} catch (AssertionFailedError e) {
			成功();
		}

		アサート("message", "a", と, "b", は異なる値);
		try {
			アサート("message", "a", と, "a", は異なる値);
			失敗();
		} catch (AssertionFailedError e) {
			成功();
		}

		アサート("message", o, と, "b", は参照先が異なる);
		try {
			アサート("message", o, と, o, は参照先が異なる);
			失敗();
		} catch (AssertionFailedError e) {
			成功();
		}

		doAssert(true, と, true, は同じ値);
		doAssert(1, と, 1, は同じ値);
	}

}
